<?php
/**
 * @author : Jegtheme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Theme JNews_Review_Backend
 */
class JNews_Review_Backend {

	/**
	 * @var JNews_Review_Backend
	 */
	private static $instance;

	/**
	 * @return JNews_Review_Backend
	 */
	public static function getInstance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}
		return static::$instance;
	}

	private function __construct() {
		add_filter( 'manage_edit-post_columns', array( $this, 'post_column' ), 9 );
		add_action( 'manage_posts_custom_column', array( $this, 'post_custom_column' ) );
	}

	public function post_custom_column( $name ) {
		global $post;

		switch ( $name ) {
			case 'review':
				$output = '';
				if ( jnews_get_metabox_value( 'jnews_review.enable_review', false ) ) {
					$output = "<div class='jnews-admin-review review-enabled'>" . esc_html__( 'Post Review', 'jnews-review' ) . '</div>';
				} else {
					$output = "<div class='jnews-admin-review review-disabled'>" . esc_html__( 'Standard', 'jnews-review' ) . '</div>';
				}
				echo jnews_sanitize_output( $output );
				break;
		}
	}

	public function post_column( $columns ) {
		$columns['review'] = 'Post Type';
		return $columns;
	}

	private function is_amp() {
		$is_amp = false;
		if ( function_exists( 'is_amp_endpoint' ) ) {
			$is_amp = is_amp_endpoint();
		}

		return $is_amp;
	}
}
